# Scalable Long Range Propagation on Continuous-Time Dynamic Graphs
This repository provides a reference implementation of our paper **Scalable Long Range Propagation on Continuous-Time Dynamic Graphs**.

## Requirements
_Note: we assume Miniconda/Anaconda is installed, otherwise see this [link](https://docs.conda.io/projects/conda/en/latest/user-guide/install/download.html) for correct installation. The proper Python version is installed during the first step of the following procedure._

Install the required packages and create the environment with create_env script
``` 
./create_env.sh 
```

or create the environment from the yml file
``` 
conda env create -f environment.yml
conda activate ctdg 
```

## Run the experiment
- Sequence classification on temporal path graphs

    ```./run_sequence.sh```

- PascalVOC

    ```./run_pascal.sh```

- Real-world C-TDG benchmarks

    ```./run_link_prediction.sh```
    
_Note: For more details on how to run the experiment launch ```python3 main.py --help```_

